﻿/*
VERSION:  1.6
	1.6		Change: depth is randomized so that many files can load at the same time without replacing each other's movieClips
	1.5		Change:	default movieClipParent to be _this
	1.4		Fixed:  BitmapData  =>  flash.display.BitmapData
	1.3		include loadImage.as locally
	1.2		added "movieClipParent" parameter.

USAGE
	#include "functions/VOW/loadBitmap.as"
	
	loadBitmap( "Basis.png" )
	.then( doStuff );
	

NOTE:
	The input path parameter be a file path or internal linkage.
	SWF files, Image files, Image linkage, and BitmapData can be loaded.  (BitmapData will theoretically get cloned and pass through)
	
DESCRIPTION:
	Uses loadImage() to load a file into a movieClip,
	then draws that movieClip into bitmapData,
	removes the temporary movieClip,
	and returns the bitmapData
	
*/
#include "loadBitmap/loadImage.as"

var _this = this;
var loadBitmap = function( fileName_str, movieClipParent ){
	var movieClipParent = movieClipParent || _this;
	var vow = VOW.make();
	
	var loadDepth = 1000 + Math.floor( Math.random() * 900000 );
	var newDepth = nextDepth(movieClipParent, null, loadDepth);
	var newName = "tempLoadedClip_"+newDepth;
	
	var loader = loadImage( fileName_str, movieClipParent, newName, newDepth, false );
	var success = function(){
		// draw into a bitmap
		var output_mc = movieClipParent[newName];
		var output_pic = new flash.display.BitmapData( output_mc._width, output_mc._height, true, 0 );
		output_pic.draw( output_mc );
		// remove the loaded temporary movieClip
		output_mc._name = "";
		output_mc.onUnload();
		output_mc.onUnload = null;
		output_mc.removeMovieClip();
		delete movieClipParent[newName];
		delete output_mc;
		
		// pass the output bitmap
		vow.keep( output_pic );
	}
	loader.onLoadInit = success;
	if(!loader)		// if:  no loader was needed
		success();
	loader.onLoadError = function(){
		var msg = "Failed to load image:  "+fileName_str;
		trace( msg );
		vow.doBreak( msg );
	}
	
	return vow.promise;
}// loadImageFile()